#include "ScriptEvents.h"

using namespace DataAccess;
using namespace std;

//Constructor for ScriptEvents class
ScriptEvents::ScriptEvents(Frame* frame) : _frame(frame)
{
	srand((unsigned)time(0));
	PATIENTTEXT = "(PATIENT)";
	PHYSICIANTEXT = "(PHYSICIANNUMBER)";

	_connection = new Connection();
	if(!_connection->Connect())
	{
		_frame->Close(TRUE);
	}
	_dataBase = _connection->GetDataBase();

	_frame->SetScriptEvents(this);
}

ScriptEvents::~ScriptEvents()
{
	delete _connection;
	delete _dataBase;
}

#pragma region ScriptEvents

//Checks to see if the script needs to be continued, if it needs to run the start-up script, or if it just needs to start normally
void ScriptEvents::CheckState()
{
	try
	{
		//Get values for the user's name and physician number
		_patientName = (new ConfigurationTableAdapter())->FillByKey(_dataBase, "PATIENT_NAME")->GetValue();
		_physicianNumber = (new ConfigurationTableAdapter())->FillByKey(_dataBase, "PHYSICIAN_NUMBER")->GetValue();

		_currentState = (new CurrentStateTableAdapter())->FillByAll(_dataBase);

		//if this is the first time running the program, the intro script is the first thing to play
		if(_currentState->GetRunStartupScript() == 1)
		{
			//set script based on intro script
			GroupControlDataRow* introGroup = (new GroupControlTableAdapter())->FillByEntry(_dataBase, 6);

			MessageDataTable* introMessageTable = (MessageTableAdapter()).FillByGroupID(_dataBase, introGroup->GetID());
			
			int random = (rand()%((int)introMessageTable->GetDataRows().size()));

			_currentMessage = new MessageDataRow(introMessageTable->GetDataRows().at(random));

			_frame->SetTextBoxText(this->ReplaceTextVariables(_currentMessage->GetText()));
			_frame->MakeHeadTalk(this->ReplaceTextVariables(_currentMessage->GetScript()));

			_frame->SetupNamePrompt();
			return;
		}

		//if the program wasn't currently in progress
		if(_currentState->GetInProgress() == 0)
		{
			//set script based on starting script
			GroupControlDataRow* startRow = (new GroupControlTableAdapter())->FillByID(_dataBase, 1);
			MessageDataTable* startTable = (new MessageTableAdapter())->FillByGroupID(_dataBase, startRow->GetID());
                
			int random = (rand()%((int)startTable->GetDataRows().size()));

			_currentMessage = new MessageDataRow(startTable->GetDataRows().at(random));

			_frame->SetTextBoxText(this->ReplaceTextVariables(_currentMessage->GetText()));
			_frame->MakeHeadTalk(this->ReplaceTextVariables(_currentMessage->GetScript()));

			this->LoadNextScene();
		}
        //if the program was currently in progress
        else
        {
			//set script based on last script message
			_currentMessage = (new MessageTableAdapter())->FillByID(_dataBase, _currentState->GetCurrentMessageID());
            this->LoadContinuedMessage();
		}

	}
	catch(...)
	{
		std::cerr << "DOESN'T WORK" << std::endl;
		_frame->Close(true);
	}
}

//Determines the next script based on Group Control entries
void ScriptEvents::LoadNextScene()
{
	_frame->ClearInputPanel();

	//gets the next script
	MessageLinkDataRow* nextQuestionRow = (new MessageLinkTableAdapter())->FillByParent(_dataBase, _currentMessage->GetID());

	GroupControlDataRow* nextGroupRow = (new GroupControlTableAdapter())->FillByID(_dataBase, nextQuestionRow->GetChild());
	MessageDataTable* nextMessagesTable = (new MessageTableAdapter())->FillByGroupID(_dataBase, nextGroupRow->GetID());

	(new CurrentStateTableAdapter())->InsertCurrentState(_dataBase, 1, 0, _currentMessage->GetID());

	//if the group is a group of statements/questions
	if(nextGroupRow->GetEntry() == 0 || nextGroupRow->GetEntry() == 10)
	{
		int random = (rand()%((int)nextMessagesTable->GetDataRows().size()));

		_currentMessage = new MessageDataRow(nextMessagesTable->GetDataRows().at(random));

		_frame->SetTextBoxText(this->ReplaceTextVariables(_currentMessage->GetText()));
		_frame->MakeHeadTalk(this->ReplaceTextVariables(_currentMessage->GetScript()));

		this->LoadNextScene();
	}
	//if the group is a group of statements that needs a continue button
	else if(nextGroupRow->GetEntry() == 1)
	{
		int random = (rand()%((int)nextMessagesTable->GetDataRows().size()));

		_currentMessage = new MessageDataRow(nextMessagesTable->GetDataRows().at(random));

		_frame->SetTextBoxText(this->ReplaceTextVariables(_currentMessage->GetText()));
		_frame->MakeHeadTalk(this->ReplaceTextVariables(_currentMessage->GetScript()));
		_frame->AddContinueButton();
	}
	//if the group is a group for glucose readings
	else if(nextGroupRow->GetEntry() == 2)
	{
		_currentMessage = new MessageDataRow(nextMessagesTable->GetDataRows().at(1));
		_frame->SetupGlucoseReading(nextMessagesTable);
	}
	//if the group is a group for pedometer readings
	else if(nextGroupRow->GetEntry() == 3)
	{
		int random = (rand()%((int)nextMessagesTable->GetDataRows().size()));

		_currentMessage = new MessageDataRow(nextMessagesTable->GetDataRows().at(random));

		_frame->SetTextBoxText(this->ReplaceTextVariables(_currentMessage->GetText()));
		_frame->MakeHeadTalk(this->ReplaceTextVariables(_currentMessage->GetScript()));
		_frame->SetupPedometerReading();
	}
	//if the group is a group for user reponse
	else if(nextGroupRow->GetEntry() == 4)
	{
		_frame->AddUserResponse(nextMessagesTable);
	}
	//if the group is a group for ending the conversation
	else if(nextGroupRow->GetEntry() == 5)
	{
		int random = (rand()%((int)nextMessagesTable->GetDataRows().size()));

		_currentMessage = new MessageDataRow(nextMessagesTable->GetDataRows().at(random));

		(new CurrentStateTableAdapter())->InsertCurrentState(_dataBase, 0, 0, _currentMessage->GetID());

		_frame->SetTextBoxText(this->ReplaceTextVariables(_currentMessage->GetText()));
		_frame->MakeHeadTalk(this->ReplaceTextVariables(_currentMessage->GetScript()));
		_frame->SetEndOfProgram();

		_frame->PlayVideo("Alice End.avi");
	}
	//if the group is the group for the name prompt
	else if(nextGroupRow->GetEntry() == 6)
	{
		int random = (rand()%((int)nextMessagesTable->GetDataRows().size()));

		_currentMessage = new MessageDataRow(nextMessagesTable->GetDataRows().at(random));

		_frame->SetTextBoxText(this->ReplaceTextVariables(_currentMessage->GetText()));
		_frame->MakeHeadTalk(this->ReplaceTextVariables(_currentMessage->GetScript()));
		_frame->SetupNamePrompt();
	}
	//doctor number input
	else if(nextGroupRow->GetEntry() == 11)
	{
		int random = (rand()%((int)nextMessagesTable->GetDataRows().size()));

		_currentMessage = new MessageDataRow(nextMessagesTable->GetDataRows().at(random));

		_frame->SetTextBoxText(this->ReplaceTextVariables(_currentMessage->GetText()));
		_frame->MakeHeadTalk(this->ReplaceTextVariables(_currentMessage->GetScript()));
		_frame->SetupPhysiciansNumber();
	}
}

//Loads a script based on the current message
void ScriptEvents::LoadContinuedMessage()
{
	_frame->ClearInputPanel();

	GroupControlDataRow* currentGroupRow = (new GroupControlTableAdapter())->FillByID(_dataBase, _currentMessage->GetGroupID());

	(new CurrentStateTableAdapter())->InsertCurrentState(_dataBase, 1, 0, _currentMessage->GetID());

	//if the group is a group of statements/questions
	if(currentGroupRow->GetEntry() == 0 || currentGroupRow->GetEntry() == 8 || currentGroupRow->GetEntry() == 9 || currentGroupRow->GetEntry() == 10)
	{
		_frame->SetTextBoxText(this->ReplaceTextVariables(_currentMessage->GetText()));
		_frame->MakeHeadTalk(this->ReplaceTextVariables(_currentMessage->GetScript()));

		this->LoadNextScene();
	}
	//if the group is a group of statements that needs a continue button
	else if(currentGroupRow->GetEntry() == 1)
	{
		_frame->SetTextBoxText(this->ReplaceTextVariables(_currentMessage->GetText()));
		_frame->MakeHeadTalk(this->ReplaceTextVariables(_currentMessage->GetScript()));
		_frame->AddContinueButton();
	}
	//if the group is a group for glucose readings
	else if(currentGroupRow->GetEntry() == 2)
	{
		MessageDataTable* nextMessagesTable = (new MessageTableAdapter())->FillByGroupID(_dataBase, currentGroupRow->GetID());
		_frame->SetupGlucoseReading(nextMessagesTable);
	}
	//if the group is a group for pedometer readings
	else if(currentGroupRow->GetEntry() == 3)
	{
		_frame->SetTextBoxText(this->ReplaceTextVariables(_currentMessage->GetText()));
		_frame->MakeHeadTalk(this->ReplaceTextVariables(_currentMessage->GetScript()));
		_frame->SetupPedometerReading();
	}
	//if the group is a group for user reponse
	else if(currentGroupRow->GetEntry() == 4)
	{
		MessageDataTable* nextMessagesTable = (new MessageTableAdapter())->FillByGroupID(_dataBase, currentGroupRow->GetID());
		_frame->AddUserResponse(nextMessagesTable);
	}
	//if the group is a group for ending the conversation
	else if(currentGroupRow->GetEntry() == 5)
	{
		(new CurrentStateTableAdapter())->InsertCurrentState(_dataBase, 0, 0, _currentMessage->GetID());

		_frame->SetTextBoxText(this->ReplaceTextVariables(_currentMessage->GetText()));
		_frame->MakeHeadTalk(this->ReplaceTextVariables(_currentMessage->GetScript()));
		_frame->SetEndOfProgram();

		_frame->PlayVideo("Alice End.avi");
	}
	//if the group is the group for the name prompt
	else if(currentGroupRow->GetEntry() == 6)
	{
		_frame->SetTextBoxText(this->ReplaceTextVariables(_currentMessage->GetText()));
		_frame->MakeHeadTalk(this->ReplaceTextVariables(_currentMessage->GetScript()));
		_frame->SetupNamePrompt();
	}
	//doctor number input
	else if(currentGroupRow->GetEntry() == 11)
	{
		_frame->SetTextBoxText(this->ReplaceTextVariables(_currentMessage->GetText()));
		_frame->MakeHeadTalk(this->ReplaceTextVariables(_currentMessage->GetScript()));
		_frame->SetupPhysiciansNumber();
	}
}

#pragma endregion

//Replaces (PATIENT) and (PHYSICIAN) in the messages' text and script varaibles with the patient's name and physicians number
string ScriptEvents::ReplaceTextVariables(string text)
{
	//replaces (PATIENT) with the patient's name
	int position = text.find(PATIENTTEXT, 0);
	if(position != -1)
	{
		text = text.replace(position, PATIENTTEXT.size(), _patientName);
	}

	//replaces (PHYSCIAN) with the physican number
	position = text.find(PHYSICIANTEXT, 0);
	if(position != -1)
	{
		text = text.replace(position, PHYSICIANTEXT.size(), _physicianNumber);
	}

	return text;
}